/*
**  DESCRIPTION
**      Daemonize routine
**
**  DEVELOPER
**      Scott C. Karlin   (scott@cs.princeton.edu)
**
**  HISTORY
**      03 Jul 2003  sck  Initial Version
**      21 Sep 2004  sck  RPM-ized; better documented
**
**  CVS ID
**      $Id$
*/
#ifndef DAEMON_H
#define DAEMON_H

/****************************************************************************/

extern void daemonize(char *dir, char *lockfile);

/*
**  DESCRIPTION
**      Daemonize the current process.  This puts the program in the
**      background where is will be detached from a controlling tty and 
**      have stdin, stdout, stderr set to /dev/null.
**
**      If the process cannot be daemonized, _exit(EXIT_FAILURE) will
**      be called.  This should probably be cleaned up.
**
**  PARAMETERS
**      dir      -  The directory where the server should run.  The root
**                  directory "/" is common as it will never be unmounted.
**      lockfile -  The lockfile where the pid of the process will be
**                  recorded.  Relative paths are relative to <dir>.
**                  If lockfile is NULL, then multiple instances of the
**                  daemon can be created.
*/
/****************************************************************************/

#endif  /* DAEMON_H */
