public class Negative {
    /* Reads image from filename given as command-line argument.
       Overwrites every color level of each pixel with its
       negative (255 - c if color level is c), then displays result.
       Example execution: java-introcs Negative picture.jpg
    */
    public static void main(String[] args) {
        String filename = args[0];
        StdPicture.read(filename);
        int width = StdPicture.width();
        int height = StdPicture.height();

        for (int col = 0; col < width; col++) {
            for (int row = 0; row < height; row++) {
                int r = StdPicture.getRed(col, row);
                int g = StdPicture.getGreen(col, row);
                int b = StdPicture.getBlue(col, row);

                // Invert color values
                StdPicture.setRGB(col, row, 255 - r, 255 - g, 255 - b);
            }
        }
        // Show picture
        StdPicture.show();
    }
}
