public class Grayscale {
    /* Reads image from filename given as command-line argument.
       Overwrites every color level of each pixel with the
       value obtained by luminance formula, then displays
       resulting grayscale image.
       Example execution: java-introcs Grayscale picture.jpg
    */
    public static void main(String[] args) {
        String filename = args[0];
        StdPicture.read(filename);
        int width = StdPicture.width();
        int height = StdPicture.height();

        for (int col = 0; col < width; col++) {
            for (int row = 0; row < height; row++) {
                int r = StdPicture.getRed(col, row);
                int g = StdPicture.getGreen(col, row);
                int b = StdPicture.getBlue(col, row);

                // Set equal r, g and b levels according to luminance formula
                int y = (int) (Math.round(0.299 * r + 0.587 * g + 0.114 * b));
                StdPicture.setRGB(col, row, y, y, y);
            }
        }
        // Show picture
        StdPicture.show();
    }
}
