public class Collatz {
    /* Reads positive long command-line argument and computes the Collatz
       sequence starting at this number: if even, next number is current
       divided by 2; if odd, next is triple of current plus 1.
       Stops when the number 1 appears in the sequence.
       Example execution: java Collatz n
    */
    public static void main(String[] args) {
        // Read long from command line
        long n = Long.parseLong(args[0]);

        System.out.println(n);
        while (n != 1) {
            // If even, divide by 2; if odd, multiply by 3 and add 1
            if (n % 2 == 0)
                n /= 2;
            else
                n = n * 3 + 1;
            System.out.println(n);
        }
    }
}
