public class Brighten {
    /* Reads image from filename given as command-line argument.
       Overwrites each pixel with the average of the color value
       and (255, 255, 255) (white), then displays result.
       Example execution: java-introcs Brighten picture.jpg
    */
    public static void main(String[] args) {
        String filename = args[0];
        StdPicture.read(filename);
        int width = StdPicture.width();
        int height = StdPicture.height();

        for (int col = 0; col < width; col++) {
            for (int row = 0; row < height; row++) {
                // Calculate brighter red, green and blue levels
                int r = (int) Math.round((StdPicture.getRed(col, row) + 255) / 2.0);
                int g = (int) Math.round((StdPicture.getGreen(col, row) + 255) / 2.0);
                int b = (int) Math.round((StdPicture.getBlue(col, row) + 255) / 2.0);

                // Set new color values to pixel
                StdPicture.setRGB(col, row, r, g, b);
            }
        }
        // Show picture
        StdPicture.show();
    }
}
