
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.ObjectOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class Show implements Serializable
{
  private MyDay theDay;
  private int theTableIndex;
  private int theChannel;
	
  private static String niceTry = "Nice try, but you won't find the decryption algorithm here.";
	
  public Show(int year, int month, int day, int tableIndex, int channel){
    this(new MyDay(year, month, day), tableIndex, channel);
  }
	
  public Show(MyDay day, int tableIndex, int channel) {
    theDay = day;
    theTableIndex = tableIndex;
    theChannel = channel;
  }
	
  public static Show fromStream(InputStream istr) throws IOException {
    ObjectInputStream ois = new ObjectInputStream(istr);
    try {
      Object obj = ois.readObject();
      return (Show)obj;
    }catch(ClassNotFoundException x){
      System.err.println("Deserialization failed: " + x);
      throw new IOException("Deserialization failed");
    }
  }
	
  public MyDay getDay() {
    return theDay;
  }
	
  public int getTableIndex() {
    return theTableIndex;
  }
	
  public int getChannel() {
    return theChannel;
  }
	
  public String toString() {
    return "Show[" + getDay()+ ", on channel " + getChannel() + ", tableindex " + theTableIndex + "]";
  }
	
  public void writeAndFlush(OutputStream ostr) throws IOException {
    ObjectOutputStream oos = new ObjectOutputStream(ostr);
    oos.writeObject(this);
    oos.flush();
  }
}
