
import java.io.OutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;

public class DecodeClient
{
  public static String ServerHost = "ux04.cs.princeton.edu";
  public static int ServerPort = 8094;
	
  private int theYear;
  private int theMonth;
	
  public DecodeClient(int year, int month) {
    theYear = year;
    theMonth = month;
  }
	
  public Show decode(int code) throws IOException {
    Socket sock = new Socket(ServerHost, ServerPort);
    DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
    InputStream is = sock.getInputStream();
    dos.writeInt(theYear);
    dos.writeInt(theMonth);
    dos.writeInt(code);
    dos.flush();
    Show ret = Show.fromStream(is);
    sock.close();
    return ret;
  }
	
  public static void main(String[] argv) throws IOException {
    if(argv.length == 0){
      argv = new String[3];
      argv[0] = "91";
      argv[1] = "5";
      argv[2] = "3316";
    }
    int year = Integer.parseInt(argv[0]);
    int month = Integer.parseInt(argv[1]);
    int code = Integer.parseInt(argv[2]);
    DecodeClient clnt = new DecodeClient(year, month);
    Show show = clnt.decode(code);
    System.out.println(show);
  }
}
