#!/usr/bin/env python

#-----------------------------------------------------------------------
# waiting.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import multiprocessing

def print_color(color):
    for _ in range(5):
        print(color)
    print(color + ' process terminated')

def main():

    blue_process = multiprocessing.Process(
        target=print_color, args=['blue'])
    red_process = multiprocessing.Process(
        target=print_color, args=['red'])

    blue_process.start()
    red_process.start()

    blue_process.join()
    red_process.join()

    print('parent process terminated')

if __name__ == '__main__':
    main()
