#!/usr/bin/env python

#-----------------------------------------------------------------------
# prodconthreads.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import threading
import queue

QUEUE_SIZE = 8  # Arbitrary

#-----------------------------------------------------------------------

class ProducerThread (threading.Thread):

    def __init__(self, intqueue):
        threading.Thread.__init__(self)
        self._intqueue = intqueue

    def run(self):
        for i in range(100):
            self._intqueue.put(i)
            print('Produced:', i)

#-----------------------------------------------------------------------

class ConsumerThread (threading.Thread):

    def __init__(self, intqueue):
        threading.Thread.__init__(self)
        self._intqueue = intqueue

    def run(self):
        for _ in range(100):
            num = self._intqueue.get()
            print('Consumed:', num)

#-----------------------------------------------------------------------

def main():

    intqueue = queue.Queue(QUEUE_SIZE)

    producer_thread = ProducerThread(intqueue)
    consumer_thread = ConsumerThread(intqueue)

    producer_thread.start()
    consumer_thread.start()

    producer_thread.join()
    consumer_thread.join()

    print('Finished')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
