#!/usr/bin/env python

#-----------------------------------------------------------------------
# prodconprocesses.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import multiprocessing

#-----------------------------------------------------------------------

def produce(producer_conn):
    for i in range(100):
        producer_conn.send(i)
        print('Produced:', i)

#-----------------------------------------------------------------------

def consume(consumer_conn):
    for _ in range(100):
        num = consumer_conn.recv()
        print('Consumed:', num)

#-----------------------------------------------------------------------

def main():

    producer_conn, consumer_conn = multiprocessing.Pipe()

    producer_process = multiprocessing.Process(
        target=produce, args=[producer_conn])
    consumer_process = multiprocessing.Process(
        target=consume, args=[consumer_conn])

    producer_process.start()
    consumer_process.start()

    producer_process.join()
    consumer_process.join()

    print('Finished')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
