#!/usr/bin/env python

#-----------------------------------------------------------------------
# joining.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import threading

#-----------------------------------------------------------------------

class PrinterThread (threading.Thread):

    def __init__(self, color):
        threading.Thread.__init__(self)
        self._color = color

    def run(self):
        for _ in range(5):
            print(self._color)
        print(self._color + ' thread terminated')

#-----------------------------------------------------------------------

def main():

    blue_thread = PrinterThread('blue')
    red_thread = PrinterThread('red')

    blue_thread.start()
    red_thread.start()

    blue_thread.join()
    red_thread.join()

    print('main thread terminated')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
