#!/usr/bin/env python

#-----------------------------------------------------------------------
# deadlockw.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import threading

#-----------------------------------------------------------------------

class BankAcct:

    def __init__(self, title):
        self._title = title
        self._balance = 0
        self._lock = threading.RLock()

    def transfer_to(self, other, amount):
        with self._lock:
            with other._lock:
                self._balance -= amount
                other._balance += amount
                print(self._title + ': ' + str(self._balance))
                print(other._title + ': ' + str(other._balance))

#-----------------------------------------------------------------------

class AliceToBobThread (threading.Thread):

    def __init__(self, alice_acct, bob_acct):
        threading.Thread.__init__(self)
        self._alice_acct = alice_acct
        self._bob_acct = bob_acct

    def run(self):
        for _ in range(1000):
            self._alice_acct.transfer_to(self._bob_acct, 1)

#-----------------------------------------------------------------------

class BobToAliceThread (threading.Thread):

    def __init__(self, bob_acct, alice_acct):
        threading.Thread.__init__(self)
        self._bob_acct = bob_acct
        self._alice_acct = alice_acct

    def run(self):
        for _ in range(1000):
            self._bob_acct.transfer_to(self._alice_acct, 1)

#-----------------------------------------------------------------------

def main():

    alice_acct = BankAcct('Alice')
    bob_acct = BankAcct('Bob')

    alice_to_bob_thread = AliceToBobThread(alice_acct, bob_acct)
    bob_to_alice_thread = BobToAliceThread(bob_acct, alice_acct)

    alice_to_bob_thread.start()
    bob_to_alice_thread.start()

    alice_to_bob_thread.join()
    bob_to_alice_thread.join()

    print('Finished')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
