#!/usr/bin/env python

#-----------------------------------------------------------------------
# daytimeserver.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import socket
import time
import multiprocessing

#-----------------------------------------------------------------------

IODELAY = int(os.environ.get('IODELAY', '0'))

#-----------------------------------------------------------------------

def handle_client(sock):

    print('Forked child process')

    try:

        # Simulate an I/O-bound server.
        time.sleep(IODELAY)

        with sock:
            datetime = time.asctime(time.localtime())
            with sock.makefile(mode='w', encoding='ascii') as flo:
                flo.write(datetime + '\n')
                #flo.flush()

        print('Closed socket in child process')
        print('Exiting child process')

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} port', file=sys.stderr)
        sys.exit(1)

    try:
        port = int(sys.argv[1])

        server_sock = socket.socket()
        print('Opened server socket')
        if os.name != 'nt':
            server_sock.setsockopt(
                socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        server_sock.bind(('', port))
        print('Bound server socket to port')
        server_sock.listen()
        print('Listening')

        while True:
            sock, _ = server_sock.accept()
            with sock:
                print('Accepted connection')
                print('Opened socket')
                process = multiprocessing.Process(
                    target=handle_client,
                    args=[sock])
                process.start()
            print('Closed socket in parent process')

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
