#!/usr/bin/env python

#-----------------------------------------------------------------------
# daytimeserver.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import socket
import time
import threading

#-----------------------------------------------------------------------

CDELAY = int(os.environ.get('CDELAY', '0'))

#-----------------------------------------------------------------------

def consume_cpu_time(delay):

    initial_thread_time = time.thread_time()
    while (time.thread_time() - initial_thread_time) < delay:
        pass

#-----------------------------------------------------------------------

class ClientHandlerThread (threading.Thread):

    def __init__(self, sock):
        threading.Thread.__init__(self)
        self._sock = sock

    def run(self):
        print('Spawned child thread')

        # Simulate a compute-bound server.
        consume_cpu_time(CDELAY)

        with self._sock:
            datetime = time.asctime(time.localtime())
            with self._sock.makefile(mode='w', encoding='ascii') as flo:
                flo.write(datetime + '\n')
                #flo.flush()

        print('Closed socket in child thread')
        print('Exiting child thread')

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} port', file=sys.stderr)
        sys.exit(1)

    try:
        port = int(sys.argv[1])

        server_sock = socket.socket()
        print('Opened server socket')
        if os.name != 'nt':
            server_sock.setsockopt(
                socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        server_sock.bind(('', port))
        print('Bound server socket to port')
        server_sock.listen()
        print('Listening')

        while True:
            try:
                sock, _ = server_sock.accept()
                print('Accepted connection')
                print('Opened socket')
                client_handler_thread = ClientHandlerThread(sock)
                client_handler_thread.start()
            except Exception as ex:
                print(f'{sys.argv[0]}: {ex}', file=sys.stderr)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
