#!/usr/bin/env python

#-----------------------------------------------------------------------
# daytimeserver.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import socket
import time

#-----------------------------------------------------------------------

CDELAY = int(os.environ.get('CDELAY', '0'))

#-----------------------------------------------------------------------

def consume_cpu_time(delay):

    initial_thread_time = time.thread_time()
    while (time.thread_time() - initial_thread_time) < delay:
        pass

#-----------------------------------------------------------------------

def handle_client(sock):

    # Simulate a compute-bound server.
    consume_cpu_time(CDELAY)

    datetime = time.asctime(time.localtime())
    with sock.makefile(mode='w', encoding='ascii') as flo:
        flo.write(datetime + '\n')
        #flo.flush()

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} port', file=sys.stderr)
        sys.exit(1)

    try:
        port = int(sys.argv[1])

        server_sock = socket.socket()
        print('Opened server socket')
        if os.name != 'nt':
            server_sock.setsockopt(
                socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        server_sock.bind(('', port))
        print('Bound server socket to port')
        server_sock.listen()
        print('Listening')

        while True:
            try:
                sock, _ = server_sock.accept()
                with sock:
                    print('Accepted connection')
                    print('Opened socket')
                    handle_client(sock)
                print('Closed socket')
            except Exception as ex:
                print(f'{sys.argv[0]}: {ex}', file=sys.stderr)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
