//----------------------------------------------------------------------
// Race.java
// Author: Bob Dondero
//----------------------------------------------------------------------

class Bank
{
   private int balance = 0;

   public int getBalance()
   {
      return balance;
   }

   public void deposit(int amount)
   {
      int temp = balance;
      temp += amount;
      System.out.println(balance);
      balance = temp;
   }

   public void withdraw(int amount)
   {
      int temp = amount;
      temp -= amount;
      System.out.println(temp);
      balance = temp;
   }
}

//----------------------------------------------------------------------

class DepositThread extends Thread
{
   private Bank bank;

   public DepositThread(Bank bank)
   {
      this.bank = bank;
   }

   public void run()
   {
      for (int i = 0; i < 10; i++)
         bank.deposit(1);
   }
}

//----------------------------------------------------------------------

class WithdrawThread extends Thread
{
   private Bank bank;

   public WithdrawThread(Bank bank)
   {
      this.bank = bank;
   }

   public void run()
   {
      for (int i = 0; i < 5; i++)
         bank.withdraw(2);
   }
}

//----------------------------------------------------------------------

public class Race
{
   public static void main(String[] args)
   {
      Bank bank = new Bank();

      Thread depositThread = new DepositThread(bank);
      Thread withdrawThread = new WithdrawThread(bank);

      depositThread.start();
      withdrawThread.start();

      try
      {
         depositThread.join();
         withdrawThread.join();
      }
      catch (InterruptedException e)
      {
         Thread.currentThread().interrupt();
      }

      System.out.println("Final balance: " + bank.getBalance());
   }
}
