#!/usr/bin/env python

#-----------------------------------------------------------------------
# euclidclient4.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import intmath.euclid

def main():

    try:
        line = input('Enter the first integer: ')
        i = int(line)

        line = input('Enter the second integer: ')
        j = int(line)

        my_gcd = intmath.euclid.gcd(i, j)
        print('gcd:', my_gcd)

        my_lcm = intmath.euclid.lcm(i, j)
        print('lcm:', my_lcm)

    except ValueError:
        print('Error: Not an integer', file=sys.stderr)
        sys.exit(1)
    except EOFError:
        print('Error: Missing integer', file=sys.stderr)
        sys.exit(1)
    except ZeroDivisionError as ex:
        print(str(ex), file=sys.stderr)
        sys.exit(1)

if __name__ == '__main__':
    main()
