#!/usr/bin/env python

#-----------------------------------------------------------------------
# euclidclient2.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys

#-----------------------------------------------------------------------

def gcd(i, j):

    if (i == 0) and (j == 0):
        raise ZeroDivisionError(
            'gcd(i,j) is undefined if i and j are 0')
    i = abs(i)
    j = abs(j)
    while j != 0:  # Euclid's algorithm
        i, j = j, i%j
    return i

#-----------------------------------------------------------------------

def lcm(i, j):

    if (i == 0) or (j == 0):
        raise ZeroDivisionError(
            'lcm(i,j) is undefined if i or j is 0')
    i = abs(i)
    j = abs(j)
    return (i // gcd(i, j)) * j

#-----------------------------------------------------------------------

def main():

    try:
        line = input('Enter the first integer: ')
        i = int(line)

        line = input('Enter the second integer: ')
        j = int(line)

        my_gcd = gcd(i, j)
        print('gcd:', my_gcd)

        my_lcm = lcm(i, j)
        print('lcm:', my_lcm)

    except ValueError:
        print('Error: Not an integer', file=sys.stderr)
        sys.exit(1)
    except EOFError:
        print('Error: Missing integer', file=sys.stderr)
        sys.exit(1)
    except ZeroDivisionError as ex:
        print(str(ex), file=sys.stderr)
        sys.exit(1)

if __name__ == '__main__':
    main()
