#!/usr/bin/env python

#-----------------------------------------------------------------------
# circle5.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import math

#-----------------------------------------------------------------------

def read_radius():

    line = input("Enter the circle's radius:\n")
    radius = int(line)
    return radius

#-----------------------------------------------------------------------

def write_results(radius, diam, circum):

    print(f'A circle with radius {radius} has diameter {diam}')
    print(f'and circumference {circum:.2f}.')

#-----------------------------------------------------------------------

def main():

    exit_status = 0

    try:
        radius = read_radius()

        diam = 2 * radius
        circum = math.pi * float(diam)

        write_results(radius, diam, circum)

    except ValueError:
        print('Error: Not an integer', file=sys.stderr)
        exit_status = 1

    except EOFError:
        print('Error: Missing integer', file=sys.stderr)
        exit_status = 1

    print('Thank you for running the program.')

    return exit_status

#-----------------------------------------------------------------------

if __name__ == '__main__':
    sys.exit(main())
