#!/usr/bin/env python

#-----------------------------------------------------------------------
# circle1options.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import math

#-----------------------------------------------------------------------

def main():

    line = input("Enter the circle's radius:\n")
    radius = int(line)

    diam = 2 * radius
    circum = math.pi * float(diam)

    # Multiple arguments:
    print('A circle with radius', radius, 'has diameter', diam)
    print('and circumference', circum, '.')

    # String concatenation:
    print('A circle with radius ' + str(radius) + ' has diameter ' +
        str(diam))
    print('and circumference ' + str(circum) + '.')

    # Old (C) style formatting:
    print('A circle with radius %d has diameter %d' % (radius, diam))
    print('and circumference %.2f.' % circum)

    # The format() method:
    print('A circle with radius {:d} has diameter {:d}'.
        format(radius, diam))
    print('and circumference {:.2f}.'.format(circum))

    # The format() method (shortcut):
    print('A circle with radius {} has diameter {}'.
        format(radius, diam))
    print('and circumference {:.2f}.'.format(circum))

    # F strings:
    print(f'A circle with radius {radius:d} has diameter {diam:d}')
    print(f'and circumference {circum:.2f}.')

    # F strings (shortcut):
    print(f'A circle with radius {radius} has diameter {diam}')
    print(f'and circumference {circum:.2f}.')

    print('Thank you for running the program.')

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
