{
  (* Header: everything betweeen { and } is exported directly to the
     beginning of the generated .ml file *)

type token =
  | A of int
  | B of int

exception End_of_file

}

  (* Lexical specification goes here *)

rule ablex = parse
  | 'a'+ as str { A (String.length str) }
  | 'b'+ as str { B (String.length str) }
  | eof { raise End_of_file }


{
  (* Footer: everything betweeen { and } is exported directly to the
     end of the generated .ml file *)

  let tokenize (str : string) : token list =
    let buf = Lexing.from_string str in
    let rec go (tokens : token list) : token list =
      try
        go ((ablex buf)::tokens)
      with End_of_file -> List.rev tokens
    in
    go []
;;

}
