
/**********************************************************************************
 *
 *  Compilation:  javac -classpath .:player.jar MP3Player.java Wave.java
 *  Execution:    java  -classpath .:player.jar MP3Player file.mp3
 *
 *  Plays an mp3 file specified as a command line input.
 *
 *  Note:  under Windows, replace the : with a ; when specifying the classpath.
 *  Note:  player.jar must be located in the current directory.
 *
 **********************************************************************************/


import javazoom.jl.player.Player;

public class MP3Player {
    public static void main(String args[]) {
        String filename = args[0];
        Player.open(filename);

        while (!Player.isEmpty()) {
            short[] left  = Player.getLeftChannel();
            short[] right = Player.getRightChannel();
            Wave w = new Wave(left, right);
            w.play();
        }

        Player.close();
    }
}
