
/**********************************************************************************
 *
 *  Compilation:  javac -classpath .:player.jar FurElise.java Wave.java
 *  Execution:    java  -classpath .:player.jar FurElise
 *
 *  Note:  under Windows, replace the : with a ; when specifying the classpath.
 *  Note:  the file player.jar must be in the current directory
 *
 *  Generates the first 9 notes of Fur Elise using the Wave class and plays them.
 *
 **********************************************************************************/

import javazoom.jl.player.Player;

public class FurElise {
    public static void main(String args[]) {
        double amplitude = 8000.0;
        Player.open();

        // Setup the notes - multiply freq by 2 to raise an octave
        Wave E  = new Wave(659.25 * 2, 0.3, amplitude);
        Wave DS = new Wave(622.25 * 2, 0.3, amplitude);
        Wave B  = new Wave(493.88 * 2, 0.3, amplitude);
        Wave D  = new Wave(587.33 * 2, 0.3, amplitude);
        Wave C  = new Wave(523.25 * 2, 0.3, amplitude);
        Wave A  = new Wave(440.00 * 2, 0.8, amplitude);

        // e, d#, e, d#, e, b, d, c, a
        E.play();
        DS.play();
        E.play();
        DS.play();
        E.play();
        B.play();
        D.play();
        C.play();
        A.play();

        Player.close();
        System.exit(0);
    }
}
