nbayes.train <- function(docs,
                         classes,
                         folds,
                         fold,
                         eps=1)
{
    nclasses    <- length(unique(classes));
    nwords      <- dim(docs)[2];
    train.docs  <- docs[folds!=fold,];
    train.class <- classes[folds!=fold];
    test.docs   <- docs[folds==fold,];
    test.class  <- classes[folds==fold];

    # compute naive Bayes model estimates

    log.class.probs <- log(as.vector(table(train.class)) / length(train.class));
    log.word.probs <- matrix(NA, nrow=nclasses, ncol=nwords);
    for (c in 1:nclasses)
    {
        log.word.probs[c,] <- colSums(train.docs[train.class==c,]) + eps;
        log.word.probs[c,] <- log(log.word.probs[c,] / sum(log.word.probs[c,]));
    }

    # classifier function
    # note: this is all in the log scale

    classify <- function(doc)
    {
        weights <- apply(log.word.probs, 1, function (x) x %*% doc);
        weights <- weights + log.class.probs;
        return(which.max(weights));
    }

    # compute training error and testing error

    info <- list();
    info$train <- accuracy(train.docs, train.class, classify)$accuracy;
    info$test <- accuracy(test.docs, test.class, classify)$accuracy;

    # return info and classifier function

    return(list(info=info, classify=classify));


}


mh.boost.train <- function(docs,
                           classes,
                           folds,
                           fold,
                           nrounds,
                           vocab)
{

}



accuracy <- function(docs,
                     classes,
                     classifier.fn,
                     compute.info=False)
{
    ndocs <- length(classes);
    predictions <- apply(docs, 1, function (d) classifier.fn(d));
    accuracy <- sum(predictions == classes) / ndocs;
    if (compute.info)
    {
        info <- data.frame(prediction=predictions, truth=classes);
    }
    else
    {
        info <-  NULL;
    }
    return(list(info=info, accuracy=accuracy));
}
