#include "util.c"

int main(int argc, char **argv)
{
    int fd;
    struct sockaddr_in addr;
    struct hostent *h;

    // Establish Connection
    if (argc != 2) {
        fprintf(stderr, "usage: tcpclnt <server name>\n");
        exit(1);
    }
    h = gethostbyname(argv[1]);
    addr.sin_family = AF_INET;
    addr.sin_port = htons(5342);
    memcpy(&addr.sin_addr, h->h_addr_list[0], sizeof(addr));
    catchError(fd = cs461_socket(PF_INET, SOCK_STREAM, 0), -1, "socket");
    catchError(cs461_connect(fd, &addr, sizeof(addr)), -1, "connect");
    printf("connection established\n");

    // Perform Read/Write Tests
    doSend(fd);
    doRecv(fd);
    doSend(fd);
    doRecv(fd);

    printf("private tests completed\n");

    doSend(fd);
    doRecv(fd);
    doSend(fd);
    doRecv(fd);

    printf("joint tests completed\n");

    // Teardown Connection
    catchError(cs461_close(fd), -1, "close");
    return 0;
}
