#!/usr/bin/env python

#-----------------------------------------------------------------------
# ipaddress.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import socket

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} domainname',
            file=sys.stderr)
        sys.exit(1)

    domain_name = sys.argv[1]

    try:
        host_name, aliases, ip_addresses = (
            socket.gethostbyname_ex(domain_name))
        print('Host name:', host_name)
        for alias in aliases:
            print('Alias:', alias)
        for ip_address in ip_addresses:
            print('IP address:', ip_address)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
