#!/usr/bin/env python

#-----------------------------------------------------------------------
# echoclient.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import socket

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} host port', file=sys.stderr)
        sys.exit(1)

    try:
        host = sys.argv[1]
        port = int(sys.argv[2])

        line = input()

        with socket.socket() as sock:
            sock.connect((host, port))

            with sock.makefile(mode='w', encoding='utf-8') as out_flo:
               out_flo.write(line + '\n')
               #out_flo.flush()

            with sock.makefile(mode='r', encoding='utf-8') as in_flo:
               echoed_line = in_flo.readline()

        if echoed_line == '':
            print('The echo server crashed', file=sys.stderr)
        else:
            print(echoed_line, end='')

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
