#!/usr/bin/env python

#-----------------------------------------------------------------------
# server.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import socket
import pickle

#-----------------------------------------------------------------------

def create_courses():
    # book0 = {'title': 'C Programming', 'price': 88.55}
    book1 = {'title': 'The Practice of Programming', 'price': 35.14}
    course0 = {'name': 'COS 217', 'book': book1}  # Shared book.
    course1 = {'name': 'COS 333', 'book': book1}  # Shared book.
    courses = [course0, course1]
    return courses

#-----------------------------------------------------------------------

def handle_client(sock):
    courses = create_courses()
    with sock.makefile(mode='wb') as flo:
        pickle.dump(courses, flo)
        #flo.flush()
    print('Wrote to client')

#-----------------------------------------------------------------------

def main():
    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} port', file=sys.stderr)
        sys.exit(1)
    try:
        port = int(sys.argv[1])
        server_sock = socket.socket()
        print('Opened server socket')
        if os.name != 'nt':
            server_sock.setsockopt(
                socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        server_sock.bind(('', port))
        server_sock.listen()
        while True:
            try:
                sock, _ = server_sock.accept()
                with sock:
                    print('Accepted connection')
                    handle_client(sock)
            except Exception as ex:
                print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
