#!/usr/bin/env python

#-----------------------------------------------------------------------
# client.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import socket
import pickle

#-----------------------------------------------------------------------

def write_courses(courses):

    for course in courses:
        print(course['name'])
        book = course['book']
        print(book['title'])
        print(book['price'])
        print()

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} host port', file=sys.stderr)
        sys.exit(1)

    try:
        host = sys.argv[1]
        port = int(sys.argv[2])

        with socket.socket() as sock:
            sock.connect((host, port))
            with sock.makefile(mode='rb') as flo:
                courses = pickle.load(flo)

        write_courses(courses)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
