#!/usr/bin/env python

#-----------------------------------------------------------------------
# client.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import socket

#-----------------------------------------------------------------------

def write_courses(courses):
    for course in courses:
        print(course['name'])
        book = course['book']
        print(book['title'])
        print(book['price'])
        print()

#-----------------------------------------------------------------------

def main():
    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} host port', file=sys.stderr)
        sys.exit(1)
    try:
        host = sys.argv[1]
        port = int(sys.argv[2])

        with socket.socket() as sock:
            sock.connect((host, port))
            with sock.makefile(mode='r', encoding='utf-8') as flo:
                courses = []

                while True:
                    course_name = flo.readline()
                    if course_name == '':
                        break
                    course_name = course_name.rstrip()

                    book_title = flo.readline()
                    if book_title == '':
                        raise Exception('Ran out of input')
                    book_title = book_title.rstrip()

                    book_price = flo.readline()
                    if book_price == '':
                        raise Exception('Ran out of input')
                    book_price = float(book_price.rstrip())

                    book = {'title': book_title, 'price': book_price}
                    course = {'name': course_name, 'book': book}
                    courses.append(course)

        write_courses(courses)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------
if __name__ == '__main__':
    main()
