#!/usr/bin/env python

#-----------------------------------------------------------------------
# order.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import contextlib
import sqlite3

#-----------------------------------------------------------------------

DATABASE_URL = 'file:bookstore.sqlite'

def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} isbn custid',
            file=sys.stderr)
        sys.exit(1)

    isbn = sys.argv[1]
    custid = sys.argv[2]

    try:
        with contextlib.closing(
            sqlite3.connect(_DATABASE_URL + '?mode=rw',
            isolation_level=None, uri=True)) as connection:
            with contextlib.closing(connection.cursor()) as cursor:
                stmt_str = f'''
                    UPDATE orders SET quantity = quantity+1
                    WHERE isbn = '{isbn}' AND custid = '{custid}'
                    '''
                cursor.execute(stmt_str)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
