#!/usr/bin/env python

#-----------------------------------------------------------------------
# display.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import contextlib
import sqlite3

#-----------------------------------------------------------------------

DATABASE_URL = 'file:bookstore.sqlite'

def main():

    if len(sys.argv) != 1:
        print(f'usage: python {sys.argv[0]}', file=sys.stderr)
        sys.exit(1)

    try:
        with contextlib.closing(
            sqlite3.connect(_DATABASE_URL + '?mode=ro',
            isolation_level=None, uri=True)) as connection:

            with contextlib.closing(connection.cursor()) as cursor:

                print('-------------------------------------------')
                print('books')
                print('-------------------------------------------')
                cursor.execute("SELECT * FROM books")
                table = cursor.fetchall()
                for row in table:
                    print(row)

                print('-------------------------------------------')
                print('authors')
                print('-------------------------------------------')
                cursor.execute("SELECT * FROM authors")
                table = cursor.fetchall()
                for row in table:
                    print(row)

                print('-------------------------------------------')
                print('zipcodes')
                print('-------------------------------------------')
                cursor.execute("SELECT * FROM zipcodes")
                table = cursor.fetchall()
                for row in table:
                    print(row)

                print('-------------------------------------------')
                print('customers')
                print('-------------------------------------------')
                cursor.execute("SELECT * FROM customers")
                table = cursor.fetchall()
                for row in table:
                    print(row)

                print('-------------------------------------------')
                print('orders')
                print('-------------------------------------------')
                cursor.execute("SELECT * FROM orders")
                table = cursor.fetchall()
                for row in table:
                    print(row)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
