#!/usr/bin/env python

#-----------------------------------------------------------------------
# create.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import contextlib
import sqlite3

#-----------------------------------------------------------------------

DATABASE_URL = 'file:bookstore.sqlite'

def main():

    if len(sys.argv) != 1:
        print(f'usage: python {sys.argv[0]}', file=sys.stderr)
        sys.exit(1)

    try:
        with contextlib.closing(
            sqlite3.connect(_DATABASE_URL + '?mode=rwc',
            isolation_level=None, uri=True)) as connection:

            with contextlib.closing(connection.cursor()) as cursor:

                cursor.execute('PRAGMA foreign_keys = ON')

                #-------------------------------------------------------

                cursor.execute('DROP TABLE IF EXISTS orders')
                cursor.execute('DROP TABLE IF EXISTS customers')
                cursor.execute('DROP TABLE IF EXISTS zipcodes')
                cursor.execute('DROP TABLE IF EXISTS authors')
                cursor.execute('DROP TABLE IF EXISTS books')

                #-------------------------------------------------------

                cursor.execute('''
                    CREATE TABLE books (
                    isbn TEXT NOT NULL,
                    title TEXT,
                    quantity INTEGER,
                    PRIMARY KEY (isbn))
                    ''')
                cursor.execute('''
                    CREATE TABLE authors (
                    isbn TEXT NOT NULL,
                    author TEXT NOT NULL,
                    PRIMARY KEY (isbn, author),
                    FOREIGN KEY (isbn) REFERENCES books(isbn))
                    ''')
                cursor.execute('''
                    CREATE TABLE zipcodes (
                        zipcode TEXT NOT NULL,
                        city TEXT,
                        state TEXT,
                        PRIMARY KEY (zipcode))
                        ''')
                cursor.execute('''
                    CREATE TABLE customers (
                        custid TEXT NOT NULL,
                        custname TEXT,
                        street TEXT,
                        zipcode TEXT,
                        PRIMARY KEY (custid),
                        FOREIGN KEY (zipcode)
                            REFERENCES zipcodes(zipcode))''')
                cursor.execute('''
                    CREATE TABLE orders (
                        isbn TEXT NOT NULL,
                        custid TEXT NOT NULL,
                        quantity INTEGER,
                        PRIMARY KEY (isbn, custid),
                        FOREIGN KEY (isbn) REFERENCES books(isbn),
                        FOREIGN KEY (custid)
                            REFERENCES customers(custid))
                        ''')

                #-------------------------------------------------------

                cursor.execute('''
                    INSERT INTO books (isbn, title, quantity)
                    VALUES ('123','The Practice of Programming',500)
                    ''')
                cursor.execute('''
                    INSERT INTO books (isbn, title, quantity)
                    VALUES ('234','The C Programming Language',800)
                    ''')
                cursor.execute('''
                    INSERT INTO books (isbn, title, quantity)
                    VALUES ('345','Algorithms in C',650)
                    ''')

                #-------------------------------------------------------

                cursor.execute('''INSERT INTO authors (isbn, author)
                   VALUES ('123','Kernighan')''')
                cursor.execute('''INSERT INTO authors (isbn, author)
                   VALUES ('123','Pike')''')
                cursor.execute('''INSERT INTO authors (isbn, author)
                   VALUES ('234','Kernighan')''')
                cursor.execute('''INSERT INTO authors (isbn, author)
                   VALUES ('234','Ritchie')''')
                cursor.execute('''INSERT INTO authors (isbn, author)
                   VALUES ('345','Sedgewick')''')

                #-------------------------------------------------------

                cursor.execute('''
                    INSERT INTO zipcodes (zipcode, city, state)
                    VALUES ('08540','Princeton', 'NJ')''')
                cursor.execute('''
                    INSERT INTO zipcodes (zipcode, city, state)
                    VALUES ('02138','Cambridge', 'MA')''')
                cursor.execute('''
                    INSERT INTO zipcodes (zipcode, city, state)
                    VALUES ('02142','Cambridge', 'MA')''')

                #-------------------------------------------------------

                cursor.execute('''
                    INSERT INTO customers
                    (custid, custname, street, zipcode) VALUES
                    ('111','Princeton','114 Nassau St','08540')''')
                cursor.execute('''
                    INSERT INTO customers
                    (custid, custname, street, zipcode) VALUES
                    ('222','Harvard','1256 Mass Ave','02138')''')
                cursor.execute('''
                    INSERT INTO customers
                    (custid, custname, street, zipcode) VALUES
                    ('333','MIT','292 Main St','02142')''')

                #-------------------------------------------------------

                cursor.execute('''
                    INSERT INTO orders (isbn, custid, quantity)
                    VALUES ('123','222',20)''')
                cursor.execute('''
                    INSERT INTO orders (isbn, custid, quantity)
                    VALUES ('345','222',100)''')
                cursor.execute('''
                    INSERT INTO orders (isbn, custid, quantity)
                    VALUES ('123','111',30)''')

    except Exception as ex:
        print(ex, file=sys.stderr)
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
