-- ---------------------------------------------------------------------
-- bookstore.sql
-- Author: Bob Dondero
-- ---------------------------------------------------------------------

PRAGMA foreign_keys = ON;

-- ---------------------------------------------------------------------

DROP TABLE IF EXISTS orders;
DROP TABLE IF EXISTS customers;
DROP TABLE IF EXISTS zipcodes;
DROP TABLE IF EXISTS authors;
DROP TABLE IF EXISTS books;

-- ---------------------------------------------------------------------

CREATE TABLE books (
   isbn TEXT NOT NULL,
   title TEXT,
   quantity INTEGER,
   PRIMARY KEY (isbn));
CREATE TABLE authors (
   isbn TEXT NOT NULL,
   author TEXT NOT NULL,
   PRIMARY KEY (isbn, author),
   FOREIGN KEY (isbn) REFERENCES books(isbn));
CREATE TABLE zipcodes (
   zipcode TEXT NOT NULL,
   city TEXT,
   state TEXT,
   PRIMARY KEY (zipcode));
CREATE TABLE customers (
   custid TEXT NOT NULL,
   custname TEXT,
   street TEXT,
   zipcode TEXT,
   PRIMARY KEY (custid),
   FOREIGN KEY (zipcode) REFERENCES zipcodes(zipcode));
CREATE TABLE orders (
   isbn TEXT NOT NULL,
   custid TEXT NOT NULL,
   quantity INTEGER,
   PRIMARY KEY (isbn, custid),
   FOREIGN KEY (isbn) REFERENCES books(isbn),
   FOREIGN KEY (custid) REFERENCES customers(custid));

-- ---------------------------------------------------------------------

INSERT INTO books (isbn, title, quantity)
   VALUES ('123','The Practice of Programming',500);
INSERT INTO books (isbn, title, quantity)
   VALUES ('234','The C Programming Language',800);
INSERT INTO books (isbn, title, quantity)
   VALUES ('345','Algorithms in C',650);

INSERT INTO authors (isbn, author)
   VALUES ('123','Kernighan');
INSERT INTO authors (isbn, author)
   VALUES ('123','Pike');
INSERT INTO authors (isbn, author)
   VALUES ('234','Kernighan');
INSERT INTO authors (isbn, author)
   VALUES ('234','Ritchie');
INSERT INTO authors (isbn, author)
   VALUES ('345','Sedgewick');

INSERT INTO zipcodes (zipcode, city, state)
   VALUES ('08540','Princeton', 'NJ');
INSERT INTO zipcodes (zipcode, city, state)
   VALUES ('02138','Cambridge', 'MA');
INSERT INTO zipcodes (zipcode, city, state)
   VALUES ('02142','Cambridge', 'MA');

INSERT INTO customers (custid, custname, street, zipcode)
   VALUES ('111','Princeton', '114 Nassau St', '08540');
INSERT INTO customers (custid, custname, street, zipcode)
   VALUES ('222','Harvard', '1256 Mass Ave', '02138');
INSERT INTO customers (custid, custname, street, zipcode)
   VALUES ('333','MIT', '292 Main St', '02142');

INSERT INTO orders (isbn, custid, quantity)
   VALUES ('123','222',20);
INSERT INTO orders (isbn, custid, quantity)
   VALUES ('345','222',100);
INSERT INTO orders (isbn, custid, quantity)
   VALUES ('123','111',30);
