#!/usr/bin/env python

#-----------------------------------------------------------------------
# recovery.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import random
import sqlalchemy
import sqlalchemy.orm
import dotenv
import database

dotenv.load_dotenv()
DATABASE_URL = os.getenv('DATABASE_URL', 'sqlite:///bookstore.sqlite')
DATABASE_URL = DATABASE_URL.replace('postgres://', 'postgresql://')
_DATABASE_URL = _DATABASE_URL.replace(
    'postgresql://', 'postgresql+psycopg://')

engine = sqlalchemy.create_engine(DATABASE_URL)

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 1:
        print(f'usage: python {sys.argv[0]}', file=sys.stderr)
        sys.exit(1)

    try:
        with sqlalchemy.orm.Session(engine) as session:

            for i in range(20):

                query = (session.query(database.Order)
                    .filter(database.Order.isbn == '123')
                    .filter(database.Order.custid == '222'))
                row = query.one()
                row.quantity += 1

                # Simulate a HW/SW failure occurring randomly.
                if random.randrange(5) == 0:
                    print(f'Simulated failure with i = {i}')
                    sys.exit(1)

                query = (session.query(database.Book)
                    .filter(database.Book.isbn == '123'))
                row = query.one()
                row.quantity -= 1

                session.commit()
                print('Transaction %d committed.' % i)

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
