#!/usr/bin/env python

#-----------------------------------------------------------------------
# order.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import sqlalchemy
import sqlalchemy.orm
import dotenv
import database

dotenv.load_dotenv()
DATABASE_URL = os.getenv('DATABASE_URL', 'sqlite:///bookstore.sqlite')
DATABASE_URL = DATABASE_URL.replace('postgres://', 'postgresql://')
_DATABASE_URL = _DATABASE_URL.replace(
    'postgresql://', 'postgresql+psycopg://')

engine = sqlalchemy.create_engine(DATABASE_URL)

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} isbn custid',
            file=sys.stderr)
        sys.exit(1)

    isbn = sys.argv[1]
    custid = sys.argv[2]

    try:
        with sqlalchemy.orm.Session(engine) as session:

            query = (session.query(database.Order)
                .filter(database.Order.isbn == isbn)
                .filter(database.Order.custid == custid))

            row = query.one()
            row.quantity += 1

            session.commit()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
