#!/usr/bin/env python

#-----------------------------------------------------------------------
# display.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import sqlalchemy
import sqlalchemy.orm
import dotenv
import database

dotenv.load_dotenv()
DATABASE_URL = os.getenv('DATABASE_URL', 'sqlite:///bookstore.sqlite')
DATABASE_URL = DATABASE_URL.replace('postgres://', 'postgresql://')
_DATABASE_URL = _DATABASE_URL.replace(
    'postgresql://', 'postgresql+psycopg://')

engine = sqlalchemy.create_engine(DATABASE_URL)

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 1:
        print(f'usage: python {sys.argv[0]}', file=sys.stderr)
        sys.exit(1)

    try:

        with sqlalchemy.orm.Session(engine) as session:

            print('-------------------------------------------')
            print('books')
            print('-------------------------------------------')
            query = session.query(database.Book)
            table = query.all()
            for row in table:
                print(row.isbn, row.title, row.quantity)

            print('-------------------------------------------')
            print('authors')
            print('-------------------------------------------')
            query = session.query(database.Author)
            table = query.all()
            for row in table:
                print(row.isbn, row.author)

            print('-------------------------------------------')
            print('zipcodes')
            print('-------------------------------------------')
            query = session.query(database.Zipcode)
            table = query.all()
            for row in table:
                print(row.zipcode, row.city, row.state)

            print('-------------------------------------------')
            print('customers')
            print('-------------------------------------------')
            query = session.query(database.Customer)
            table = query.all()
            for row in table:
                print(row.custid, row.custname, row.street, row.zipcode)

            print('-------------------------------------------')
            print('orders')
            print('-------------------------------------------')
            query = session.query(database.Order)
            table = query.all()
            for row in table:
                print(row.isbn, row.custid, row.quantity)

        engine.dispose()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
