#!/usr/bin/env python

#-----------------------------------------------------------------------
# database.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sqlalchemy
import sqlalchemy.orm

class Base(sqlalchemy.orm.DeclarativeBase):
    pass

class Book (Base):
    __tablename__ = 'books'
    isbn = sqlalchemy.Column(sqlalchemy.String,
        primary_key=True, nullable=False)
    title = sqlalchemy.Column(sqlalchemy.String)
    quantity = sqlalchemy.Column(sqlalchemy.Integer)

class Author (Base):
    __tablename__ = 'authors'
    isbn = sqlalchemy.Column(sqlalchemy.String,
        sqlalchemy.ForeignKey('books.isbn'),
        primary_key=True, nullable=False)
    author = sqlalchemy.Column(sqlalchemy.String,
        primary_key=True, nullable=False)
    #books = sqlalchemy.orm.relationship('Book', backref='authors')

class Zipcode (Base):
    __tablename__ = 'zipcodes'
    zipcode = sqlalchemy.Column(sqlalchemy.String,
        primary_key=True, nullable=False)
    city = sqlalchemy.Column(sqlalchemy.String)
    state = sqlalchemy.Column(sqlalchemy.String)

class Customer (Base):
    __tablename__ = 'customers'
    custid = sqlalchemy.Column(sqlalchemy.String,
        primary_key=True, nullable=False)
    custname = sqlalchemy.Column(sqlalchemy.String)
    street = sqlalchemy.Column(sqlalchemy.String)
    zipcode = sqlalchemy.Column(sqlalchemy.String,
        sqlalchemy.ForeignKey('zipcodes.zipcode'))
    #zipcodes=sqlalchemy.orm.relationship('Zipcode',backref='customers')

class Order (Base):
    __tablename__ = 'orders'
    isbn = sqlalchemy.Column(sqlalchemy.String,
        sqlalchemy.ForeignKey('books.isbn'),
        primary_key=True, nullable=False)
    custid = sqlalchemy.Column(sqlalchemy.String,
        sqlalchemy.ForeignKey('customers.custid'),
        primary_key=True, nullable=False)
    quantity = sqlalchemy.Column(sqlalchemy.Integer)
