#!/usr/bin/env python

#-----------------------------------------------------------------------
# authorsearch.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import sqlalchemy
import sqlalchemy.orm
import dotenv
import database

dotenv.load_dotenv()
DATABASE_URL = os.getenv('DATABASE_URL', 'sqlite:///bookstore.sqlite')
DATABASE_URL = DATABASE_URL.replace('postgres://', 'postgresql://')
_DATABASE_URL = _DATABASE_URL.replace(
    'postgresql://', 'postgresql+psycopg://')

engine = sqlalchemy.create_engine(DATABASE_URL)

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} author', file=sys.stderr)
        sys.exit(1)

    author = sys.argv[1]

    try:
        with sqlalchemy.orm.Session(engine) as session:

            query = (session.query(database.Book.isbn,
                database.Book.title, database.Book.quantity)
                .filter(database.Book.isbn == database.Author.isbn)
                .filter(database.Author.author == author))
            print(query)

            table = query.all()
            for row in table:
                print('ISBN:', row.isbn)
                print('Title:', row.title)
                print('Quantity:', row.quantity)
                print()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
