#!/usr/bin/env python

#-----------------------------------------------------------------------
# recovery.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import random
import psycopg
import dotenv

dotenv.load_dotenv()
DATABASE_URL = os.environ['DATABASE_URL']

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 1:
        print(f'usage: python {sys.argv[0]}', file=sys.stderr)
        sys.exit(1)

    try:
        connection = psycopg.connect(DATABASE_URL)
        cursor = connection.cursor()

        for i in range(20):
            stmt_str = '''
                UPDATE orders SET quantity = quantity+1
                WHERE isbn = '123' AND custid = '222'
                '''
            cursor.execute(stmt_str)

            # Simulate a HW/SW failure occurring randomly.
            if random.randrange(10) == 0:
                print(f'Simulated failure with i = {i}')
                sys.exit(1)

            stmt_str = '''
                UPDATE books SET quantity = quantity-1
                WHERE isbn = '123'
                '''
            cursor.execute(stmt_str)
            connection.commit()
            print('Transaction %d committed.' % i)

        cursor.close()
        connection.close()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
