#!/usr/bin/env python

#-----------------------------------------------------------------------
# order.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import psycopg
import dotenv

dotenv.load_dotenv()
DATABASE_URL = os.environ['DATABASE_URL']

#-----------------------------------------------------------------------


def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} isbn custid',
            file=sys.stderr)
        sys.exit(1)

    isbn = sys.argv[1]
    custid = sys.argv[2]

    try:
        with psycopg.connect(DATABASE_URL) as connection:
            with connection.cursor() as cursor:
                stmt_str = f'''
                    UPDATE orders SET quantity = quantity+1
                    WHERE isbn = '{isbn}' AND custid = '{custid}'
                    '''
                cursor.execute(stmt_str)
                connection.commit()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
