#!/usr/bin/env python

#-----------------------------------------------------------------------
# authorsearch.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import os
import sys
import psycopg
import dotenv

dotenv.load_dotenv()
DATABASE_URL = os.environ['DATABASE_URL']

#-----------------------------------------------------------------------

def main():

    if len(sys.argv) != 2:
        print(f'usage: python {sys.argv[0]} author', file=sys.stderr)
        sys.exit(1)

    author = sys.argv[1]

    try:
        with psycopg.connect(DATABASE_URL) as connection:
            with connection.cursor() as cursor:
                stmt_str = f'''
                    SELECT books.isbn, title, quantity
                    FROM books, authors
                    WHERE books.isbn = authors.isbn
                    AND author = '{author}'
                    '''
                cursor.execute(stmt_str)
                table = cursor.fetchall()
                for row in table:
                    print('ISBN:', row[0])
                    print('Title:', row[1])
                    print('Quantity:', row[2])
                    print()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------

if __name__ == '__main__':
    main()
