#!/usr/bin/env python

#-----------------------------------------------------------------------
# queue.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

class _Node:

    def __init__(self, item):
        self._item = item
        self._next = None
    def get_item(self):
        return self._item
    def get_next(self):
        return self._next
    def set_next(self, next):
        self._next = next

class Queue:

    def __init__(self):
        self._head_node = None
        self._tail_node = None

    def put(self, item):
        new_node = _Node(item)
        if self._tail_node is None:
            self._head_node = new_node
        else:
            self._tail_node.set_next(new_node)
        self._tail_node = new_node

    def get(self):
        if self._head_node is None:
            raise Exception('Empty queue')
        item = self._head_node.get_item()
        self._head_node = self._head_node.get_next()
        if self._head_node is None:
            self._tail_node = None
        return item

    def is_empty(self):
        return self._head_node is None
