#!/usr/bin/env python

#-----------------------------------------------------------------------
# priorityqueueclient.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import priorityqueue

def main():

    pqueue = priorityqueue.PriorityQueue()

    print('Enter non-negative ints, one per line.')
    print('Enter a negative int to stop.')

    try:
        line = input()
        item = int(line)
        while item >= 0:
            pqueue.put(item)
            line = input()
            item = int(line)

        while not pqueue.is_empty():
            item = pqueue.get()
            print(item)

    except Exception as ex:
        print(ex, file=sys.stderr)
        sys.exit(1)

if __name__ == '__main__':
    main()
