#!/usr/bin/env python

#-----------------------------------------------------------------------
# priorityqueue.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import queue

class PriorityQueue (queue.Queue):

    def put(self, item):
        new_node = queue._Node(item)

        if self._head_node is None:
            self._head_node = new_node
            self._tail_node = new_node
            return

        prev_node = None
        curr_node = self._head_node
        while curr_node is not None:
            if curr_node.get_item() < item:
                if prev_node is None:
                    self._head_node = new_node
                else:
                    prev_node.set_next(new_node)
                new_node.set_next(curr_node)
                return
            prev_node = curr_node
            curr_node = curr_node.get_next()

        self._tail_node.set_next(new_node)
        self._tail_node = new_node
