#!/usr/bin/env python

#-----------------------------------------------------------------------
# euclid.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

def gcd(i, j):

    if (i == 0) and (j == 0):
        raise ZeroDivisionError(
            'gcd(i,j) is undefined if i and j are 0')

    i = abs(i)
    j = abs(j)
    while j != 0:  # Euclid's algorithm
        i, j = j, i%j
    return i

#-----------------------------------------------------------------------

def lcm(i, j):

    if (i == 0) or (j == 0):
        raise ZeroDivisionError(
            'lcm(i,j) is undefined if i or j is 0')

    i = abs(i)
    j = abs(j)
    return (i // gcd(i, j)) * j
