#!/usr/bin/env python

#-----------------------------------------------------------------------
# fraction1client.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys
import fractionprelim as fraction

def main():

    try:
        line = input('Numerator 1: ')
        num1 = int(line)
        line = input('Denominator 1: ')
        den1 = int(line)
        line = input('Numerator 2: ')
        num2 = int(line)
        line = input('Denominator 2: ')
        den2 = int(line)

        frac1 = fraction.Fraction(num1, den1)
        print('frac1:', frac1.to_string())

        frac2 = fraction.Fraction(num2, den2)
        print('frac2:', frac2.to_string())

        if frac1.equals(frac2):
            print('frac1 equals frac2')
        if not frac1.equals(frac2):
            print('frac1 does not equal frac2')

        comparison = frac1.compare_to(frac2)
        if comparison < 0:
            print('frac1 is less than frac2')
        if comparison > 0:
            print('frac1 is greater than frac2')
        if comparison <= 0:
            print('frac1 is less than or equal to frac2')
        if comparison >= 0:
            print('frac1 is greater than or equal to frac2')

        frac3 = frac1.negate()
        print('-frac1:', frac3.to_string())

        frac3 = frac1.add(frac2)
        print('frac1 + frac2:', frac3.to_string())

        frac3 = frac1.subtract(frac2)
        print('frac1 - frac2:', frac3.to_string())

        frac3 = frac1.multiply(frac2)
        print('frac1 * frac2:', frac3.to_string())

        frac3 = frac1.divide(frac2)
        print('frac1 / frac2:', frac3.to_string())

    except Exception as ex:
        print(str(ex), file=sys.stderr)
        sys.exit(1)

#-----------------------------------------------------------------------
if __name__ == '__main__':
    main()
