#!/usr/bin/env python

#-----------------------------------------------------------------------
# fraction.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import euclid

#-----------------------------------------------------------------------

class Fraction:

    def __init__(self, num=0, den=1):
        if den == 0:
            raise ZeroDivisionError('Denominator cannot be 0')
        self._num = num
        self._den = den
        self._normalize()

    def _normalize(self):
        if self._den < 0:
            self._num *= -1
            self._den *= -1
        if self._num == 0:
            self._den = 1
        else:
            gcden = euclid.gcd(self._num, self._den)
            self._num //= gcden
            self._den //= gcden

    def __str__(self):
        if self._den == 1:
            return str(self._num)
        return '%d/%d' % (self._num, self._den)

    def __eq__(self, other):
        return (self._num == other._num) and (self._den == other._den)

    def __ne__(self, other):
        return not self == other

    def __lt__(self, other):
        return (self._num * other._den) < (other._num * self._den)

    def __gt__(self, other):
        return (self._num * other._den) > (other._num * self._den)

    def __le__(self, other):
        return not self > other

    def __ge__(self, other):
        return not self < other

    def __neg__(self):
        return Fraction(-self._num, self._den)

    def __add__(self, other):
        new_num = (self._num * other._den) + (other._num * self._den)
        new_den = self._den * other._den
        return Fraction(new_num, new_den)

    def __sub__(self, other):
        new_num = (self._num * other._den) - (other._num * self._den)
        new_den = self._den * other._den
        return Fraction(new_num, new_den)

    def __mul__(self, other):
        new_num = self._num * other._num
        new_den = self._den * other._den
        return Fraction(new_num, new_den)

    def __truediv__(self, other):
        new_num = self._num * other._den
        new_den = self._den * other._num
        return Fraction(new_num, new_den)
