#!/usr/bin/env python

#-----------------------------------------------------------------------
# copystringsfinally.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys

def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} infile outfile',
            file=sys.stderr)
        sys.exit(1)

    in_name = sys.argv[1]
    out_name = sys.argv[2]

    try:
        in_file = open(in_name, mode='r', encoding='utf-8')
        try:
            out_file = open(out_name, mode='w', encoding='utf-8')
            try:
                for line in in_file:
                    out_file.write(line)
            finally:
                out_file.close()
        finally:
            in_file.close()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

if __name__ == '__main__':
    main()
