#!/usr/bin/env python

#-----------------------------------------------------------------------
# copystrings.py
# Author: Bob Dondero
#-----------------------------------------------------------------------

import sys

def main():

    if len(sys.argv) != 3:
        print(f'usage: python {sys.argv[0]} infile outfile',
            file=sys.stderr)
        sys.exit(1)

    in_name = sys.argv[1]
    out_name = sys.argv[2]

    try:
        in_file = open(in_name, mode='r', encoding='utf-8')
        out_file = open(out_name, mode='w', encoding='utf-8')

        #line = in_file.readline()
        #while line != '':
        #    out_file.write(line)
        #    line = in_file.readline()

        for line in in_file:
            out_file.write(line)

        out_file.close()
        in_file.close()

    except Exception as ex:
        print(f'{sys.argv[0]}: {ex}', file=sys.stderr)
        sys.exit(1)

if __name__ == '__main__':
    main()
